using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.EFR.BO;

namespace VIRP.EFR.DAL
{
	public partial class REFERRAL_ORIGINALDB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public REFERRAL_ORIGINALDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public REFERRAL_ORIGINAL GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 ID)
		{
			REFERRAL_ORIGINAL objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_REFERRAL_ORIGINAL_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, ID).FirstOrDefault();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
        }
        public REFERRAL_ORIGINAL GetItemByReferral_ID(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID)
        {
            REFERRAL_ORIGINAL objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_REFERRAL_ORIGINAL_getitemByReferral_ID(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<REFERRAL_ORIGINAL> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<REFERRAL_ORIGINAL> objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_REFERRAL_ORIGINAL_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
        }

        public List<REFERRAL_DETAIL_ORIGINAL> GetOriginalHealthFactorsComplete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID)
        {
            List<REFERRAL_DETAIL_ORIGINAL> objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_REFERRAL_ORIGINAL_getHealthFactorsComplete(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public int Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, REFERRAL_ORIGINAL objSave)
		{
			Int32? objReturn = objSave.ID;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_REFERRAL_ORIGINAL_save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave.ADDRESS_LINE1, objSave.ADDRESS_LINE2, objSave.ADDRESS_LINE3, objSave.CITY, objSave.COMMENT_TEXT, objSave.COUNTRY, objSave.COUNTY, objSave.CREATED, objSave.CREATEDBY, objSave.DUPLICATE_FLAG, ref objReturn, objSave.InsertedDate, objSave.ORDERBY_PROVIDER_ADDRESS_LINE1, objSave.ORDERBY_PROVIDER_ADDRESS_LINE2, objSave.ORDERBY_PROVIDER_ADDRESS_LINE3, objSave.ORDERBY_PROVIDER_CITY, objSave.ORDERBY_PROVIDER_COUNTRY, objSave.ORDERBY_PROVIDER_EMAIL, objSave.ORDERBY_PROVIDER_FAX, objSave.ORDERBY_PROVIDER_ID_NUMBER, objSave.ORDERBY_PROVIDER_NAME, objSave.ORDERBY_PROVIDER_PHONE, objSave.ORDERBY_PROVIDER_POSTAL_CODE, objSave.ORDERBY_PROVIDER_STATE, objSave.ORDERBY_PROVIDER_ZIP_PLUS_4, objSave.PATIENT_ID, objSave.POSTAL_CODE, objSave.PROVIDER_ADDRESS_LINE1, objSave.PROVIDER_ADDRESS_LINE2, objSave.PROVIDER_ADDRESS_LINE3, objSave.PROVIDER_CITY, objSave.PROVIDER_COUNTRY, objSave.PROVIDER_COUNTY, objSave.PROVIDER_EMAIL, objSave.PROVIDER_FAX, objSave.PROVIDER_ID_NUMBER, objSave.PROVIDER_NAME, objSave.PROVIDER_PHONE, objSave.PROVIDER_POSTAL_CODE, objSave.PROVIDER_STATE, objSave.PROVIDER_ZIP_PLUS_4, objSave.REFERRAL_CLASS_TEXT, objSave.REFERRAL_DATE, objSave.REFERRAL_ID, objSave.REVIEW_BY, objSave.REVIEW_DATE, objSave.STATE, objSave.STD_INSTITUTION_ID, objSave.STD_REFERRALRANK_ID, objSave.STD_REFERRALSTS_ID, objSave.STD_REGISTRY_ID, objSave.STD_REMINDERCLASS_ID, objSave.UPDATED, objSave.UPDATEDBY, objSave.VAMC_CONTACT_EMAIL, objSave.VAMC_CONTACT_FAX, objSave.VAMC_CONTACT_NAME, objSave.VAMC_CONTACT_PHONE, objSave.ZIP_PLUS_4);
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn.GetValueOrDefault();
        }

        public Int32 SaveOriginalHealthFactors(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, int REFERRAL_ID, string HFIDS, string EFP_COMMENT, string BET_COMMENT, string AI_COMMENT, string SCI_COMMENT)
        {
            Int32? objReturn = 0;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_REFERRAL_ORIGINAL_saveHealthFactors(CURRENT_USER,
                        CURRENT_REGISTRY_ID,
                        REFERRAL_ID,
                        HFIDS,
                        EFP_COMMENT,
                        BET_COMMENT,
                        AI_COMMENT,
                        SCI_COMMENT);
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn.GetValueOrDefault();
        }

        public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 ID)
		{
			Boolean objReturn = false;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_REFERRAL_ORIGINAL_delete(CURRENT_USER, CURRENT_REGISTRY_ID, ID);
					objReturn = true;
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		#endregion
	}
}
